<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
[//lasso
	// copy error message and code in case they get reset
	var(
		'msg' = error_msg,
		'code' = error_code
	);

	// do everything within a protect block to avoid unwanted recursion	
	protect;
		// set HTTP status to 500 ISE
		$__http_header__ = string_replaceregexp(
			$__http_header__,
			-find='(^HTTP\\S+)\\s+.*?\r\n',
			-replace='\\1 500 Internal Server Error\r\n'
		);
		
		if($code);
			// log error to error database
			var('desc') = ('[' + client_url + '] ' + $code + ': ' + $msg);		
			log_critical($desc);
		/if;
	/protect;
]
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />		
		<title>500 Internal Server Error</title>
		<link rel="stylesheet" type="text/css" href="/lib/styles/error.css" />
	</head>
	<body>
		<h1>500 Internal Server Error</h1>
		<p>
			An error has occurred. The error has been logged and the system administrator has been notified.
			You may go back and try again now, or, if the error persists, try again later. We apologize for
			the inconvenience.
		</p>
		<pre>
			Error Code: [$code]<br />
			[$msg]
		</pre>
	</body>
</html>
